<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;

use Dcblogdev\MsGraph\Facades\MsGraph;
use GuzzleHttp\Client;

class AuthController extends Controller
{
    //
    public function login()
    {
        return view('auth.login');
    }

      public function connect()
    {
        // Instanciamos directamente MsGraph
        $msGraph = new MsGraph();

        // Solo desactiva SSL en local
        if (app()->environment('local')) {
            $client = new Client([
                'verify' => false, // DESACTIVA SSL
            ]);

            // Pasamos el cliente de Guzzle al constructor de MsGraph
            $msGraph->setHttpClient($client);
        }

        return $msGraph->connect();
    }


    public function logout()
    {
        return MsGraph::disconnect();
    }
}
