## Community

There is a Discord community. https://discord.gg/VYau8hgwrm For quick help, ask questions in the appropriate channel.

# Laravel Microsoft Graph

[![Latest Version on Packagist](https://img.shields.io/packagist/v/dcblogdev/laravel-microsoft-graph.svg?style=flat-square)](https://packagist.org/packages/dcblogdev/laravel-microsoft-graph)
[![Total Downloads](https://img.shields.io/packagist/dt/dcblogdev/laravel-microsoft-graph.svg?style=flat-square)](https://packagist.org/packages/dcblogdev/laravel-microsoft-graph)

![Logo](https://repository-images.githubusercontent.com/145239529/9d8d5e00-1d0d-11eb-840a-2e75d658e4a2)

A Laravel package for working with Microsoft Graph API.

MsGraph comes in two flavours:

1) MsGraph: login in as a user.
2) MsGraphAdmin: login as a tenant (administrator) useful for running background tasks.

API documentation can be found at https://developer.microsoft.com/en-us/graph/docs/api-reference/beta/beta-overview

# Documentation and install instructions 
[https://dcblog.dev/docs/laravel-microsoft-graph](https://dcblog.dev/docs/laravel-microsoft-graph)

## Change log

Please see the [changelog][3] for more information on what has changed recently.

## Contributing

Contributions are welcome and will be fully credited.

Contributions are accepted via Pull Requests on [Github][4].

## Pull Requests

- **Document any change in behaviour** - Make sure the `readme.md` and any other relevant documentation are kept up-to-date.

- **Consider our release cycle** - We try to follow [SemVer v2.0.0][5]. Randomly breaking public APIs is not an option.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

## Security

If you discover any security related issues, please email dave@dcblog.dev email instead of using the issue tracker.

## License

license. Please see the [license file][6] for more information.

[2]:    https://aad.portal.azure.com/#blade/Microsoft_AAD_IAM/ActiveDirectoryMenuBlade/Overview
[3]:    changelog.md
[4]:    https://github.com/dcblogdev/laravel-microsoft-graph
[5]:    http://semver.org/
[6]:    license.md
